/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.exprcomp;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.IFieldCollection;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWCompiler;

public class VWExpr {
    private static VWCompiler myCompiler = new VWCompiler();

    protected VWExpr() {
    }

    public static String[] compileVWExpr(String theExpr, IFieldCollection theMainFields, IFieldCollection theAlternateFields, boolean theAllowFieldNames, VWCompiledExpr theOutExpr) throws VWException {
        return VWExpr.compileVWExpr(theExpr, theMainFields, null, theAlternateFields, null, theAllowFieldNames, theOutExpr);
    }

    public static String[] compileVWExpr(String theExpr, IFieldCollection theMainFields, IFieldCollection theInheritedFields, IFieldCollection theAlternateFields, IFieldCollection theInheritedAlternateFields, boolean theAllowFieldNames, VWCompiledExpr theOutExpr) throws VWException {
        String[] errors;
        if (theOutExpr == null) {
            throw new VWException("vw.base.ExpressionCompilation.NullOutputExpr", "Parameter theOutExpr is null.");
        }
        if (theExpr == null || theExpr.length() == 0) {
            String[] fakeSyntaxErrorArray = new String[]{new VWString("vw.base.ExpressionCompilation.NullExpr", "Parameter theExpr is null or empty.").toString()};
            return fakeSyntaxErrorArray;
        }
        String expression = theExpr;
        if (theOutExpr instanceof VWCompiledRefExpr && !theExpr.startsWith(":=")) {
            expression = ":=" + theExpr;
        }
        if ((errors = myCompiler.CompileVWExpr(expression, theMainFields, theInheritedFields, theAlternateFields, theInheritedAlternateFields, theAllowFieldNames, theOutExpr)) == null || errors != null && errors.length == 0) {
            return null;
        }
        if (VWExpr.myCompiler.propertyList != null) {
            VWExpr.myCompiler.propertyList.clear();
        }
        return errors;
    }

    public static void debug(boolean debug) {
        myCompiler = new VWCompiler(debug);
    }
}

